<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T16:29:31.200995776 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="C1-Nano" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Bound">
        <series color="19,148,180" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundC1NanoCPU_CYCLES &gt; 0), min(($BackendBoundC1NanoSTALL_SLOT_BACKEND / (3 * $BackendBoundC1NanoCPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Busy Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to issue queues being full to accept operations for execution" expression="if(($BackendBusyBoundC1NanoSTALL_BACKEND &gt; 0), min(($BackendBusyBoundC1NanoSTALL_BACKEND_BUSY / $BackendBusyBoundC1NanoSTALL_BACKEND), 1), 0)" name="Backend Busy Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Busy LS Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to memory system issue queues being full to accept operations for execution" expression="if(($BackendBusyLSBoundC1NanoSTALL_BACKEND &gt; 0), min(($BackendBusyLSBoundC1NanoIMP_STALL_BACKEND_BUSY_LS / $BackendBusyLSBoundC1NanoSTALL_BACKEND), 1), 0)" name="Backend Busy LS Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Busy VPU Arbitration Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to VPU arbitration preventing the VPU from accepting operations for execution" expression="if(($BackendBusyVPUArbitrationBoundC1NanoSTALL_BACKEND &gt; 0), min(($BackendBusyVPUArbitrationBoundC1NanoIMP_STALL_BACKEND_BUSY_VPU_ARB / $BackendBusyVPUArbitrationBoundC1NanoSTALL_BACKEND), 1), 0)" name="Backend Busy VPU Arbitration Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Cache L1D Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 1 data cache misses" expression="if((($BackendCacheL1DBoundC1NanoSTALL_BACKEND_L1D + $BackendCacheL1DBoundC1NanoSTALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL1DBoundC1NanoSTALL_BACKEND_L1D / ($BackendCacheL1DBoundC1NanoSTALL_BACKEND_L1D + $BackendCacheL1DBoundC1NanoSTALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L1D Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Cache L2D Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by level 2 data cache misses" expression="if((($BackendCacheL2DBoundC1NanoSTALL_BACKEND_L1D + $BackendCacheL2DBoundC1NanoSTALL_BACKEND_MEM) &gt; 0), min(($BackendCacheL2DBoundC1NanoSTALL_BACKEND_MEM / ($BackendCacheL2DBoundC1NanoSTALL_BACKEND_L1D + $BackendCacheL2DBoundC1NanoSTALL_BACKEND_MEM)), 1), 0)" name="Backend Cache L2D Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME Backpressure Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as the SME unit is busy due to other reasons like the SME unit being power down(TBD)" expression="if(($BackendSMEBackpressureBoundC1NanoSTALL_BACKEND_BUSY_CME &gt; 0), min(($BackendSMEBackpressureBoundC1NanoSTALL_BACKEND_BUSY_CMEBOUND / $BackendSMEBackpressureBoundC1NanoSTALL_BACKEND_BUSY_CME), 1), 0)" name="Backend SME Backpressure Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME Arbitration Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend because an SME is busy. The instruction cannot be sent to SME because it is waiting for arbitration." expression="if(($BackendSMEArbitrationBoundC1NanoSTALL_BACKEND_BUSY_CME &gt; 0), min(($BackendSMEArbitrationBoundC1NanoSTALL_BACKEND_BUSY_CME_ARB / $BackendSMEArbitrationBoundC1NanoSTALL_BACKEND_BUSY_CME), 1), 0)" name="Backend SME Arbitration Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME Busy Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as the SME unit is busy" expression="if(($BackendSMEBusyBoundC1NanoSTALL_BACKEND_BUSY &gt; 0), min(($BackendSMEBusyBoundC1NanoSTALL_BACKEND_BUSY_CME / $BackendSMEBusyBoundC1NanoSTALL_BACKEND_BUSY), 1), 0)" name="Backend SME Busy Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME CPU Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the SME unit of the backend due to dependency to the other units of CPU for execution" expression="if(($BackendSMECPUBoundC1NanoSTALL_BACKEND_BUSY_CME &gt; 0), min(($BackendSMECPUBoundC1NanoSTALL_BACKEND_BUSY_CME_CPUBOUND / $BackendSMECPUBoundC1NanoSTALL_BACKEND_BUSY_CME), 1), 0)" name="Backend SME CPU Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Core Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($BackendCoreBoundC1NanoSTALL_BACKEND &gt; 0), min(($BackendCoreBoundC1NanoSTALL_BACKEND_CPUBOUND / $BackendCoreBoundC1NanoSTALL_BACKEND), 1), 0)" name="Backend Core Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Core SME Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to the resource constraints to dispatch to the SME" expression="if(($BackendCoreSMEBoundC1NanoSTALL_BACKEND_CPUBOUND &gt; 0), min(($BackendCoreSMEBoundC1NanoSTALL_BACKEND_BUSY_CME / $BackendCoreSMEBoundC1NanoSTALL_BACKEND_CPUBOUND), 1), 0)" name="Backend Core SME Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Memory Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to backend core resource constraints related to memory access latency issues caused by memory access components" expression="if(($BackendMemoryBoundC1NanoSTALL_BACKEND &gt; 0), min(($BackendMemoryBoundC1NanoSTALL_BACKEND_MEMBOUND / $BackendMemoryBoundC1NanoSTALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Mem Cache Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to memory latency issues caused by data cache misses" expression="if(($BackendMemCacheBoundC1NanoSTALL_BACKEND_MEMBOUND &gt; 0), min((($BackendMemCacheBoundC1NanoSTALL_BACKEND_L1D + $BackendMemCacheBoundC1NanoSTALL_BACKEND_MEM) / $BackendMemCacheBoundC1NanoSTALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Mem Cache Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME LSRT Barrier Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as the SME unit is busy because a CPU barrier waits for SME load/store transaction completion" expression="if(($BackendSMELSRTBarrierBoundC1NanoSTALL_BACKEND_MEM_CME &gt; 0), min(($BackendSMELSRTBarrierBoundC1NanoSTALL_BACKEND_MEM_CME_BARRIER / $BackendSMELSRTBarrierBoundC1NanoSTALL_BACKEND_MEM_CME), 1), 0)" name="Backend SME LSRT Barrier Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Memory SME Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend caused by load or store address hazards caused by SME unit memory execution dependency SME and PE share the CPU memory subsystem and are synchronized via the LSRT block, causing memory execution units in them to have dependencies on data accesses" expression="if(($BackendMemorySMEBoundC1NanoSTALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemorySMEBoundC1NanoSTALL_BACKEND_MEM_CME / $BackendMemorySMEBoundC1NanoSTALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Memory SME Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME Memory Hazard CPU Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to a SME LSRT hazard causing SME instructions to stall. SME and PE share the CPU memory subsystem and are synchronized via the LSRT block, causing both the execution units to have dependencies on data accesses." expression="if(($BackendSMEMemoryHazardCPUBoundC1NanoSTALL_BACKEND_MEM_CME &gt; 0), min(($BackendSMEMemoryHazardCPUBoundC1NanoSTALL_BACKEND_MEM_CME_HZ_ON_CPU / $BackendSMEMemoryHazardCPUBoundC1NanoSTALL_BACKEND_MEM_CME), 1), 0)" name="Backend SME Memory Hazard CPU Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend SME LSRT Full Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as the SME unit is busy due to the LSRT being full. SME and PE share the CPU memory subsystem and are synchronized via the LSRT block, causing both execution units to have dependencies on data accesses." expression="if(($BackendSMELSRTFullBoundC1NanoSTALL_BACKEND_MEM_CME &gt; 0), min(($BackendSMELSRTFullBoundC1NanoSTALL_BACKEND_MEM_CME_LSRT_FULL / $BackendSMELSRTFullBoundC1NanoSTALL_BACKEND_MEM_CME), 1), 0)" name="Backend SME LSRT Full Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend CPU Memory Hazard SME Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend as the SME unit is busy due SME LSRT hazard causing CPU instructions to stall. SME and PE share the CPU memory subsystem and are synchronized via the LSRT block, causing both execution units to have dependencies on data accesses." expression="if(($BackendCPUMemoryHazardSMEBoundC1NanoSTALL_BACKEND_MEM_CME &gt; 0), min(($BackendCPUMemoryHazardSMEBoundC1NanoSTALL_BACKEND_MEM_CPU_HZ_ON_CME / $BackendCPUMemoryHazardSMEBoundC1NanoSTALL_BACKEND_MEM_CME), 1), 0)" name="Backend CPU Memory Hazard SME Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Mem Store Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to memory write pending caused by stores stalled in the pre-commit stage" expression="if(($BackendMemStoreBoundC1NanoSTALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemStoreBoundC1NanoSTALL_BACKEND_ST / $BackendMemStoreBoundC1NanoSTALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Mem Store Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Mem Tlb Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to memory access latency issues caused by data TLB misses" expression="if(($BackendMemTlbBoundC1NanoSTALL_BACKEND_MEMBOUND &gt; 0), min(($BackendMemTlbBoundC1NanoSTALL_BACKEND_TLB / $BackendMemTlbBoundC1NanoSTALL_BACKEND_MEMBOUND), 1), 0)" name="Backend Mem Tlb Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stall Interlock Rate">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to instruction interlocks. A high rate of interlock stalls is likely an indication of sub-optimal instruction scheduling for an in-order core." expression="if(($BackendStallInterlockRateC1NanoSTALL_BACKEND &gt; 0), min(($BackendStallInterlockRateC1NanoSTALL_BACKEND_ILOCK / $BackendStallInterlockRateC1NanoSTALL_BACKEND), 1), 0)" name="Backend Stall Interlock Rate" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stall memory source interlock">
        <series color="19,148,180" description="This metric is the percentage of backend stalls due to an interlock, where the source of at least one interlock is a memory operation. Refer to `backend_mem_bound` and subsequent breakdown to check whether the interlock is likely affected by memory resources such as caches or TLBs, or is instead primarily affected by load-to-use latency." expression="if(($BackendStallMemorySourceInterlockC1NanoSTALL_BACKEND &gt; 0), min(($BackendStallMemorySourceInterlockC1NanoIMP_STALL_BACKEND_ILOCK_LS / $BackendStallMemorySourceInterlockC1NanoSTALL_BACKEND), 1), 0)" name="Backend Stall memory source interlock" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stall pointer chase interlock Rate">
        <series color="19,148,180" description="This metric is the percentage of backend stalls due to a pointer chase interlock - that is, the source of at least one interlock is a memory instruction, and the destination is the address of another memory instruction. Refer to `backend_mem_bound` and subsequent breakdown to check whether the interlock is likely affected by memory resources such as caches or TLBs, or is instead primarily affected by load-to-use latency." expression="if(($BackendStallPointerChaseInterlockRateC1NanoSTALL_BACKEND &gt; 0), min(($BackendStallPointerChaseInterlockRateC1NanoIMP_STALL_BACKEND_ILOCK_LS_INTO_AGU / $BackendStallPointerChaseInterlockRateC1NanoSTALL_BACKEND), 1), 0)" name="Backend Stall pointer chase interlock Rate" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stall VPU source interlock">
        <series color="19,148,180" description="This metric is the percentage of backend stalls due to an interlock, where the source of at least one interlock is a VPU operation" expression="if(($BackendStallVPUSourceInterlockC1NanoSTALL_BACKEND &gt; 0), min(($BackendStallVPUSourceInterlockC1NanoIMP_STALL_BACKEND_ILOCK_VPU / $BackendStallVPUSourceInterlockC1NanoSTALL_BACKEND), 1), 0)" name="Backend Stall VPU source interlock" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesC1NanoCPU_CYCLES &gt; 0), min(($BackendStalledCyclesC1NanoSTALL_BACKEND / $BackendStalledCyclesC1NanoCPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Bad Speculation">
        <series color="19,148,180" description="This metric is the percentage of total slots that executed operations and didn't retire due to a pipeline flush This indicates cycles that were utilized but inefficiently" expression="if(($BadSpeculationC1NanoCPU_CYCLES &gt; 0) &amp;&amp; ($BadSpeculationC1NanoOP_SPEC &gt; 0), min((((1 - ($BadSpeculationC1NanoSTALL_SLOT / (3 * $BadSpeculationC1NanoCPU_CYCLES))) * (1 - ($BadSpeculationC1NanoOP_RETIRED / $BadSpeculationC1NanoOP_SPEC))) + ($BadSpeculationC1NanoSTALL_FRONTEND_FLUSH / $BadSpeculationC1NanoCPU_CYCLES)), 1), 0)" name="Bad Speculation" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Direct Percentage">
        <series color="19,148,180" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageC1NanoBR_RETIRED &gt; 0), min(($BranchDirectPercentageC1NanoBR_IMMED_RETIRED / $BranchDirectPercentageC1NanoBR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Indirect Percentage">
        <series color="19,148,180" description="This metric measures the ratio of indirect branches retired, including function returns, to the total number of branches architecturally executed" expression="if(($BranchIndirectPercentageC1NanoBR_RETIRED &gt; 0), min(($BranchIndirectPercentageC1NanoBR_IND_RETIRED / $BranchIndirectPercentageC1NanoBR_RETIRED), 1), 0)" name="Branch Indirect Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Misprediction Percentage">
        <series color="19,148,180" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageC1NanoBR_RETIRED &gt; 0), min(($BranchMispredictionPercentageC1NanoBR_MIS_PRED_RETIRED / $BranchMispredictionPercentageC1NanoBR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch MPKI">
        <series color="19,148,180" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKIC1NanoINST_RETIRED &gt; 0), (($BranchMPKIC1NanoBR_MIS_PRED_RETIRED / $BranchMPKIC1NanoINST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Operations Percentage">
        <series color="19,148,180" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageC1NanoINST_SPEC &gt; 0), min((($BranchOperationsPercentageC1NanoBR_IMMED_SPEC + $BranchOperationsPercentageC1NanoBR_INDIRECT_SPEC) / $BranchOperationsPercentageC1NanoINST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Return Percentage">
        <series color="19,148,180" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageC1NanoBR_RETIRED &gt; 0), min(($BranchReturnPercentageC1NanoBR_RETURN_RETIRED / $BranchReturnPercentageC1NanoBR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Bus Read Request Average Latency">
        <series color="19,148,180" description="This metric measures the average latency of read requests made by this processor on the system bus in CPU cycles" expression="if(($BusReadRequestAverageLatencyC1NanoBUS_REQ_RD &gt; 0), ($BusReadRequestAverageLatencyC1NanoBUS_REQ_RD_PERCYC / $BusReadRequestAverageLatencyC1NanoBUS_REQ_RD), 0)" name="Bus Read Request Average Latency" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Compare and Swap Far Percentage">
        <series color="19,148,180" description="This metric measures the ratio of compare and swap instructions that did not execute locally to the PE to the total compare and swap instructions" expression="if(($CompareAndSwapFarPercentageC1NanoCAS_SPEC &gt; 0), min((1 - ($CompareAndSwapFarPercentageC1NanoCAS_NEAR_SPEC / $CompareAndSwapFarPercentageC1NanoCAS_SPEC)), 1), 0)" name="Compare and Swap Far Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Compare and Swap Near Fail Percentage">
        <series color="19,148,180" description="This metric measures the ratio of failed compare and swap instructions speculatively executed locally to the PE that do not update the location accessed to the total near compare and swap instructions" expression="if(($CompareAndSwapNearFailPercentageC1NanoCAS_NEAR_SPEC &gt; 0), min((1 - ($CompareAndSwapNearFailPercentageC1NanoCAS_NEAR_PASS / $CompareAndSwapNearFailPercentageC1NanoCAS_NEAR_SPEC)), 1), 0)" name="Compare and Swap Near Fail Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Compare and Swap Near Pass Percentage">
        <series color="19,148,180" description="This metric measures the ratio of passed compare and swap instructions speculatively executed locally to the PE that updated the location accessed to the total near compare and swap instructions" expression="if(($CompareAndSwapNearPassPercentageC1NanoCAS_NEAR_SPEC &gt; 0), min(($CompareAndSwapNearPassPercentageC1NanoCAS_NEAR_PASS / $CompareAndSwapNearPassPercentageC1NanoCAS_NEAR_SPEC), 1), 0)" name="Compare and Swap Near Pass Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Compare and Swap Near Percentage">
        <series color="19,148,180" description="This metric measures the ratio of compare and swap instructions speculatively executed locally to the PE to the total compare and swap instructions" expression="if(($CompareAndSwapNearPercentageC1NanoCAS_SPEC &gt; 0), min(($CompareAndSwapNearPercentageC1NanoCAS_NEAR_SPEC / $CompareAndSwapNearPercentageC1NanoCAS_SPEC), 1), 0)" name="Compare and Swap Near Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Allocation Cycles Percentage">
        <series color="19,148,180" description="This metric is measures the ratio of cycles where the CPU had an SME allocated to it, such that the SME and Streaming SVE state of the CPU is held in that SME to the total number of CPU cycles" expression="if(($SMEAllocationCyclesPercentageC1NanoCPU_CYCLES &gt; 0), min(($SMEAllocationCyclesPercentageC1NanoCYCLES_CME_ALLOC / $SMEAllocationCyclesPercentageC1NanoCPU_CYCLES), 1), 0)" name="SME Allocation Cycles Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME Arithmetic EU Utilization">
        <series color="19,148,180" description="This metric measures the average number of operations executed by the ALU execution unit per cycle" expression="if(($SMEArithmeticEUUtilizationC1NanoCME_CYCLES &gt; 0), ($SMEArithmeticEUUtilizationC1NanoCME_OP_ALU_ISSUE / $SMEArithmeticEUUtilizationC1NanoCME_CYCLES), 0)" name="SME Arithmetic EU Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Arbitration Pending Cycles Percentage">
        <series color="19,148,180" description="This metric is measures the ratio of cycles where the CPU is in arbitration while attempting to access an SME to the total number of CPU cycles" expression="if(($SMEArbitrationPendingCyclesPercentageC1NanoCPU_CYCLES &gt; 0), min(($SMEArbitrationPendingCyclesPercentageC1NanoCYCLES_ARB_PENDING_CME / $SMEArbitrationPendingCyclesPercentageC1NanoCPU_CYCLES), 1), 0)" name="SME Arbitration Pending Cycles Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Backend Bound">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of SME" expression="if(($SMEBackendBoundC1NanoCME_CYCLES &gt; 0), min(($SMEBackendBoundC1NanoCME_STALL_BACKEND / $SMEBackendBoundC1NanoCME_CYCLES), 1), 0)" name="SME Backend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Backend Core Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to DP issue queues not accepting instructions" expression="if(($SMEBackendCoreBoundC1NanoCME_STALL_BACKEND &gt; 0), min(($SMEBackendCoreBoundC1NanoCME_STALL_BACKEND_CORE / $SMEBackendCoreBoundC1NanoCME_STALL_BACKEND), 1), 0)" name="SME Backend Core Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Backend Memory Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to Load-Store issue queues not accepting instructions" expression="if(($SMEBackendMemoryBoundC1NanoCME_STALL_BACKEND &gt; 0), min(($SMEBackendMemoryBoundC1NanoCME_STALL_BACKEND_MEM / $SMEBackendMemoryBoundC1NanoCME_STALL_BACKEND), 1), 0)" name="SME Backend Memory Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Backend Cache Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend for memory resource constraints, with the oldest instruction in at least one of the LS issue queues waiting for cache arbitration" expression="if(($SMEBackendCacheBoundC1NanoCME_STALL_BACKEND_MEM &gt; 0), min(($SMEBackendCacheBoundC1NanoCME_STALL_BACKEND_MEM_CACHE / $SMEBackendCacheBoundC1NanoCME_STALL_BACKEND_MEM), 1), 0)" name="SME Backend Cache Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Backend Store Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to Load-Store issue queues not accepting instructions" expression="if(($SMEBackendStoreBoundC1NanoCME_STALL_BACKEND_MEM &gt; 0), min(($SMEBackendStoreBoundC1NanoCME_STALL_BACKEND_MEM_STORE / $SMEBackendStoreBoundC1NanoCME_STALL_BACKEND_MEM), 1), 0)" name="SME Backend Store Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Backend Prefetch Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to hardware prefetcher issue queues not accepting instructions" expression="if(($SMEBackendPrefetchBoundC1NanoCME_STALL_BACKEND &gt; 0), min(($SMEBackendPrefetchBoundC1NanoCME_STALL_BACKEND_PF / $SMEBackendPrefetchBoundC1NanoCME_STALL_BACKEND), 1), 0)" name="SME Backend Prefetch Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME Bus Access Average Length">
        <series color="19,148,180" description="This metric measures the average length of bus accesses taken for all the bus requests made by SME" expression="if(($SMEBusAccessAverageLengthC1NanoCME_BUS_REQ &gt; 0), ($SMEBusAccessAverageLengthC1NanoCME_BUS_ACCESS / $SMEBusAccessAverageLengthC1NanoCME_BUS_REQ), 0)" name="SME Bus Access Average Length" units="accesses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Frontend Bound">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of SME" expression="if(($SMEFrontendBoundC1NanoCME_CYCLES &gt; 0), min(($SMEFrontendBoundC1NanoCME_STALL_FRONTEND / $SMEFrontendBoundC1NanoCME_CYCLES), 1), 0)" name="SME Frontend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Frontend CPU Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by no instructions sent by CPU" expression="if(($SMEFrontendCPUBoundC1NanoCME_STALL_FRONTEND &gt; 0), min(($SMEFrontendCPUBoundC1NanoCME_STALL_FRONTEND_CPU / $SMEFrontendCPUBoundC1NanoCME_STALL_FRONTEND), 1), 0)" name="SME Frontend CPU Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Frontend Other CPU Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by no instructions sent by CPU" expression="if(($SMEFrontendOtherCPUBoundC1NanoCME_STALL_FRONTEND &gt; 0), min(($SMEFrontendOtherCPUBoundC1NanoCME_STALL_FRONTEND_OTHER_CPU / $SMEFrontendOtherCPUBoundC1NanoCME_STALL_FRONTEND), 1), 0)" name="SME Frontend Other CPU Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME IPC">
        <series color="19,148,180" description="This metric measures the number of SME instructions retired per SME cycles" expression="if(($SMEIPCC1NanoCME_CYCLES &gt; 0), (($SMEIPCC1NanoCME_INST_RETIRED / $SMEIPCC1NanoCME_CYCLES) * 100), 0)" name="SME IPC" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="IQ DP0 Stall Percentage">
        <series color="19,148,180" description="This metric measures the percentage of backend stall cycles where at least one operation is waiting to issue to the issue queue DP0, but it is full" expression="if(($IQDP0StallPercentageC1NanoCME_STALL_BACKEND &gt; 0), min(($IQDP0StallPercentageC1NanoCME_DISPATCH_STALL_IQ_DP0 / $IQDP0StallPercentageC1NanoCME_STALL_BACKEND), 1), 0)" name="IQ DP0 Stall Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="IQ DP1 Stall Percentage">
        <series color="19,148,180" description="This metric measures the percentage of backend stall cycles where at least one operation is waiting to issue to the issue queue DP1, but it is full" expression="if(($IQDP1StallPercentageC1NanoCME_STALL_BACKEND &gt; 0), min(($IQDP1StallPercentageC1NanoCME_DISPATCH_STALL_IQ_DP1 / $IQDP1StallPercentageC1NanoCME_STALL_BACKEND), 1), 0)" name="IQ DP1 Stall Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="IQ Load Stall Percentage">
        <series color="19,148,180" description="This metric measures the percentage of backend stall cycles where at least one operation is waiting to issue to the issue queue LD, but it is full" expression="if(($IQLoadStallPercentageC1NanoCME_STALL_BACKEND &gt; 0), min(($IQLoadStallPercentageC1NanoCME_DISPATCH_STALL_IQ_LD / $IQLoadStallPercentageC1NanoCME_STALL_BACKEND), 1), 0)" name="IQ Load Stall Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME L1D Cache Prefetcher Accuracy">
        <series color="19,148,180" description="This metric measures SME L1D cache prefetcher accuracy" expression="if(($SMEL1DCachePrefetcherAccuracyC1NanoCME_L1D_CACHE_REFILL_HWPRF &gt; 0), (($SMEL1DCachePrefetcherAccuracyC1NanoCME_L1D_CACHE_HIT_RW_FHWPRF + $SMEL1DCachePrefetcherAccuracyC1NanoCME_L1D_LFB_HIT_RW_FHWPRF) / $SMEL1DCachePrefetcherAccuracyC1NanoCME_L1D_CACHE_REFILL_HWPRF), 0)" name="SME L1D Cache Prefetcher Accuracy" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME L1D Cache Prefetcher Coverage">
        <series color="19,148,180" description="This metric measures L1D cache prefetcher coverage" expression="if((((($SMEL1DCachePrefetcherCoverageC1NanoCME_L1D_CACHE_HIT_RW_FHWPRF + $SMEL1DCachePrefetcherCoverageC1NanoCME_L1D_LFB_HIT_RW_FHWPRF) + $SMEL1DCachePrefetcherCoverageC1NanoCME_L1D_CACHE_REFILL_RD) + $SMEL1DCachePrefetcherCoverageC1NanoCME_L1D_CACHE_REFILL_WR) &gt; 0), (($SMEL1DCachePrefetcherCoverageC1NanoCME_L1D_CACHE_HIT_RW_FHWPRF + $SMEL1DCachePrefetcherCoverageC1NanoCME_L1D_LFB_HIT_RW_FHWPRF) / ((($SMEL1DCachePrefetcherCoverageC1NanoCME_L1D_CACHE_HIT_RW_FHWPRF + $SMEL1DCachePrefetcherCoverageC1NanoCME_L1D_LFB_HIT_RW_FHWPRF) + $SMEL1DCachePrefetcherCoverageC1NanoCME_L1D_CACHE_REFILL_RD) + $SMEL1DCachePrefetcherCoverageC1NanoCME_L1D_CACHE_REFILL_WR)), 0)" name="SME L1D Cache Prefetcher Coverage" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME L1D Cache Prefetcher Timeliness">
        <series color="19,148,180" description="This metric measures SME L1D cache prefetcher timeliness" expression="if((($SMEL1DCachePrefetcherTimelinessC1NanoCME_L1D_CACHE_HIT_RW_FHWPRF + $SMEL1DCachePrefetcherTimelinessC1NanoCME_L1D_LFB_HIT_RW_FHWPRF) &gt; 0), ($SMEL1DCachePrefetcherTimelinessC1NanoCME_L1D_CACHE_HIT_RW_FHWPRF / ($SMEL1DCachePrefetcherTimelinessC1NanoCME_L1D_CACHE_HIT_RW_FHWPRF + $SMEL1DCachePrefetcherTimelinessC1NanoCME_L1D_LFB_HIT_RW_FHWPRF)), 0)" name="SME L1D Cache Prefetcher Timeliness" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME L1D Cache Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache access hits to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($SMEL1DCacheHitPercentageC1NanoCME_L1D_CACHE &gt; 0), min(($SMEL1DCacheHitPercentageC1NanoCME_L1D_CACHE_HIT / $SMEL1DCacheHitPercentageC1NanoCME_L1D_CACHE), 1), 0)" name="SME L1D Cache Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of SME level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($SMEL1DCacheMissPercentageC1NanoCME_L1D_CACHE &gt; 0), min(($SMEL1DCacheMissPercentageC1NanoCME_L1D_CACHE_REFILL / $SMEL1DCacheMissPercentageC1NanoCME_L1D_CACHE), 1), 0)" name="SME L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of SME level 1 data cache accesses missed per thousand SME instructions executed" expression="if(($SMEL1DCacheMPKIC1NanoCME_INST_RETIRED &gt; 0), (($SMEL1DCacheMPKIC1NanoCME_L1D_CACHE_REFILL / $SMEL1DCacheMPKIC1NanoCME_INST_RETIRED) * 1000), 0)" name="SME L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME L3D Cache Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of SME level 3 cache access hits to the total number of level 3 cache accesses, requested by the SME" expression="if(($SMEL3DCacheHitPercentageC1NanoCME_L3D_CACHE &gt; 0), min(($SMEL3DCacheHitPercentageC1NanoCME_L3D_CACHE_HIT / $SMEL3DCacheHitPercentageC1NanoCME_L3D_CACHE), 1), 0)" name="SME L3D Cache Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME L3D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of SME level 3 cache accesses missed to the total number of level 3 cache accesses, requested by the SME" expression="if(($SMEL3DCacheMissPercentageC1NanoCME_L3D_CACHE &gt; 0), min(($SMEL3DCacheMissPercentageC1NanoCME_L3D_CACHE_REFILL / $SMEL3DCacheMissPercentageC1NanoCME_L3D_CACHE), 1), 0)" name="SME L3D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME L3D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of SME level 3 cache accesses missed per thousand SME instructions executed" expression="if(($SMEL3DCacheMPKIC1NanoCME_INST_RETIRED &gt; 0), (($SMEL3DCacheMPKIC1NanoCME_L3D_CACHE_REFILL / $SMEL3DCacheMPKIC1NanoCME_INST_RETIRED) * 1000), 0)" name="SME L3D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME LL Cache Read Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of SME last level cache read accesses hit in the cache to the total number of SME last level cache accesses" expression="if(($SMELLCacheReadHitPercentageC1NanoCME_LL_CACHE_RD &gt; 0), min((($SMELLCacheReadHitPercentageC1NanoCME_LL_CACHE_RD - $SMELLCacheReadHitPercentageC1NanoCME_LL_CACHE_MISS_RD) / $SMELLCacheReadHitPercentageC1NanoCME_LL_CACHE_RD), 1), 0)" name="SME LL Cache Read Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME LL Cache Read Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of SME last level cache read accesses missed to the total number of last level cache accesses requested by the SME" expression="if(($SMELLCacheReadMissPercentageC1NanoCME_LL_CACHE_RD &gt; 0), min(($SMELLCacheReadMissPercentageC1NanoCME_LL_CACHE_MISS_RD / $SMELLCacheReadMissPercentageC1NanoCME_LL_CACHE_RD), 1), 0)" name="SME LL Cache Read Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME LL Cache Read MPKI">
        <series color="19,148,180" description="This metric measures the number of SME last level cache read accesses missed per SME thousand instructions executed" expression="if(($SMELLCacheReadMPKIC1NanoCME_INST_RETIRED &gt; 0), (($SMELLCacheReadMPKIC1NanoCME_LL_CACHE_MISS_RD / $SMELLCacheReadMPKIC1NanoCME_INST_RETIRED) * 1000), 0)" name="SME LL Cache Read MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Load Operations Percentage">
        <series color="19,148,180" description="This metric measures SME load operations as a percentage of SME operations speculatively executed" expression="if(($SMELoadOperationsPercentageC1NanoCME_INST_RETIRED &gt; 0), min(($SMELoadOperationsPercentageC1NanoCME_LD_SPEC / $SMELoadOperationsPercentageC1NanoCME_INST_RETIRED), 1), 0)" name="SME Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SME MAC EU Utilization">
        <series color="19,148,180" description="This metric measures the average number of operations executed by the MAC execution unit per cycle" expression="if(($SMEMACEUUtilizationC1NanoCME_CYCLES &gt; 0), ($SMEMACEUUtilizationC1NanoCME_OP_MAC_ISSUE / $SMEMACEUUtilizationC1NanoCME_CYCLES), 0)" name="SME MAC EU Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Matmul Datapath EU Utilization">
        <series color="19,148,180" description="This metric measures the average number of operations executed by the Matmul data path execution unit per cycle" expression="if(($MatmulDatapathEUUtilizationC1NanoCME_CYCLES &gt; 0), ($MatmulDatapathEUUtilizationC1NanoCME_OP_MMDP_ISSUE / $MatmulDatapathEUUtilizationC1NanoCME_CYCLES), 0)" name="Matmul Datapath EU Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Matmul Move EU Utilization">
        <series color="19,148,180" description="This metric measures the average number of operations executed by the Matmul move execution unit per cycle" expression="if(($MatmulMoveEUUtilizationC1NanoCME_CYCLES &gt; 0), ($MatmulMoveEUUtilizationC1NanoCME_OP_MMMV_ISSUE / $MatmulMoveEUUtilizationC1NanoCME_CYCLES), 0)" name="Matmul Move EU Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Permute EU Utilization">
        <series color="19,148,180" description="This metric measures the average number of operations executed by the permute execution unit per cycle" expression="if(($PermuteEUUtilizationC1NanoCME_CYCLES &gt; 0), ($PermuteEUUtilizationC1NanoCME_OP_PERM_ISSUE / $PermuteEUUtilizationC1NanoCME_CYCLES), 0)" name="Permute EU Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Retiring">
        <series color="19,148,180" description="This metric is the percentage of cycles that were not stalled for any reason" expression="if(($SMERetiringC1NanoCME_CYCLES &gt; 0), min(((($SMERetiringC1NanoCME_CYCLES - $SMERetiringC1NanoCME_STALL_FRONTEND) - $SMERetiringC1NanoCME_STALL_BACKEND) / $SMERetiringC1NanoCME_CYCLES), 1), 0)" name="SME Retiring" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Store EU Utilization">
        <series color="19,148,180" description="This metric measures the average number of operations executed by the store execution unit per cycle" expression="if(($StoreEUUtilizationC1NanoCME_CYCLES &gt; 0), ($StoreEUUtilizationC1NanoCME_OP_ST_ISSUE / $StoreEUUtilizationC1NanoCME_CYCLES), 0)" name="Store EU Utilization" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($SMEStoreOperationsPercentageC1NanoCME_INST_RETIRED &gt; 0), min(($SMEStoreOperationsPercentageC1NanoCME_ST_SPEC / $SMEStoreOperationsPercentageC1NanoCME_INST_RETIRED), 1), 0)" name="SME Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME System DRAM Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of DRAM hits to the total memory accesses that missed in the private L1 cache of SME. This metric indicates that the workload is memory bound obtaining data from the local DRAM." expression="if(($SMESystemDRAMHitPercentageC1NanoCME_L1D_CACHE_REFILL &gt; 0), min(($SMESystemDRAMHitPercentageC1NanoCME_DRAM_ACCESS / $SMESystemDRAMHitPercentageC1NanoCME_L1D_CACHE_REFILL), 1), 0)" name="SME System DRAM Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME System L3D Cache Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of L3 cache hits to the total memory accesses that missed in the private L1 cache of SME. This metric indicates that the workload is memory bound obtaining data from L3 cache." expression="if(($SMESystemL3DCacheHitPercentageC1NanoCME_L1D_CACHE_REFILL &gt; 0), min(($SMESystemL3DCacheHitPercentageC1NanoCME_L3D_CACHE_HIT / $SMESystemL3DCacheHitPercentageC1NanoCME_L1D_CACHE_REFILL), 1), 0)" name="SME System L3D Cache Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME System Last Level Cache Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of Last level cache hits to the total memory accesses that missed in the private L1 cache of SME. This metric indicates that the workload is memory bound obtaining data from LL cache." expression="if(($SMESystemLastLevelCacheHitPercentageC1NanoCME_L1D_CACHE_REFILL &gt; 0), min(($SMESystemLastLevelCacheHitPercentageC1NanoCME_LL_CACHE_HIT / $SMESystemLastLevelCacheHitPercentageC1NanoCME_L1D_CACHE_REFILL), 1), 0)" name="SME System Last Level Cache Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Cycles Per Instruction">
        <series color="19,148,180" description="This metric measures the number of cycles per instructions retired" expression="if(($CyclesPerInstructionC1NanoINST_RETIRED &gt; 0), ($CyclesPerInstructionC1NanoCPU_CYCLES / $CyclesPerInstructionC1NanoINST_RETIRED), 0)" name="Cycles Per Instruction" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Crypto Operations Percentage">
        <series color="19,148,180" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageC1NanoINST_SPEC &gt; 0), min(($CryptoOperationsPercentageC1NanoCRYPTO_SPEC / $CryptoOperationsPercentageC1NanoINST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="DTLB MPKI">
        <series color="19,148,180" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKIC1NanoINST_RETIRED &gt; 0), (($DTLBMPKIC1NanoDTLB_WALK / $DTLBMPKIC1NanoINST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="DTLB Walk Average Depth of Accesses">
        <series color="19,148,180" description="This metric measures the average depth of the data TLB walks for a data TLB refill" expression="if(($DTLBWalkAverageDepthOfAccessesC1NanoDTLB_WALK &gt; 0), ($DTLBWalkAverageDepthOfAccessesC1NanoDTLB_STEP / $DTLBWalkAverageDepthOfAccessesC1NanoDTLB_WALK), 0)" name="DTLB Walk Average Depth of Accesses" units="accesses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="DTLB Walk Average Latency">
        <series color="19,148,180" description="This metric measures the average latency of data TLB walks in CPU cycles" expression="if(($DTLBWalkAverageLatencyC1NanoDTLB_WALK &gt; 0), ($DTLBWalkAverageLatencyC1NanoDTLB_WALK_PERCYC / $DTLBWalkAverageLatencyC1NanoDTLB_WALK), 0)" name="DTLB Walk Average Latency" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Block Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks that returned a block to the total number of data TLB accesses. Block size is any memory block larger than the page granule size set by the system." expression="if(($DTLBWalkBlockPercentageC1NanoL1D_TLB &gt; 0), min(($DTLBWalkBlockPercentageC1NanoDTLB_WALK_BLOCK / $DTLBWalkBlockPercentageC1NanoL1D_TLB), 1), 0)" name="DTLB Walk Block Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Large Page Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkLargePagePercentageC1NanoL1D_TLB &gt; 0), min(($DTLBWalkLargePagePercentageC1NanoDTLB_WALK_LARGE / $DTLBWalkLargePagePercentageC1NanoL1D_TLB), 1), 0)" name="DTLB Walk Large Page Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Page Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks that returned a page to the total number of data TLB accesses. Page size is determined by the page granule size set by the system." expression="if(($DTLBWalkPagePercentageC1NanoL1D_TLB &gt; 0), min(($DTLBWalkPagePercentageC1NanoDTLB_WALK_PAGE / $DTLBWalkPagePercentageC1NanoL1D_TLB), 1), 0)" name="DTLB Walk Page Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageC1NanoL1D_TLB &gt; 0), min(($DTLBWalkPercentageC1NanoDTLB_WALK / $DTLBWalkPercentageC1NanoL1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Small Page Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks that returned large page to the total number of data TLB accesses" expression="if(($DTLBWalkSmallPagePercentageC1NanoL1D_TLB &gt; 0), min(($DTLBWalkSmallPagePercentageC1NanoDTLB_WALK_SMALL / $DTLBWalkSmallPagePercentageC1NanoL1D_TLB), 1), 0)" name="DTLB Walk Small Page Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Half Precision Floating Point Percentage">
        <series color="19,148,180" description="This metric measures half-precision floating point operations as a percentage of operations speculatively executed" expression="if(($HalfPrecisionFloatingPointPercentageC1NanoINST_SPEC &gt; 0), min(($HalfPrecisionFloatingPointPercentageC1NanoFP_HP_SPEC / $HalfPrecisionFloatingPointPercentageC1NanoINST_SPEC), 1), 0)" name="Half Precision Floating Point Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Single Precision Floating Point Percentage">
        <series color="19,148,180" description="This metric measures single-precision floating point operations as a percentage of operations speculatively executed" expression="if(($SinglePrecisionFloatingPointPercentageC1NanoINST_SPEC &gt; 0), min(($SinglePrecisionFloatingPointPercentageC1NanoFP_SP_SPEC / $SinglePrecisionFloatingPointPercentageC1NanoINST_SPEC), 1), 0)" name="Single Precision Floating Point Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Double Precision Floating Point Percentage">
        <series color="19,148,180" description="This metric measures double-precision floating point operations as a percentage of operations speculatively executed" expression="if(($DoublePrecisionFloatingPointPercentageC1NanoINST_SPEC &gt; 0), min(($DoublePrecisionFloatingPointPercentageC1NanoFP_DP_SPEC / $DoublePrecisionFloatingPointPercentageC1NanoINST_SPEC), 1), 0)" name="Double Precision Floating Point Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Bound">
        <series color="19,148,180" description="This metric is the percentage of total slots that were stalled due to resource constraints in the frontend of the processor" expression="if(($FrontendBoundC1NanoCPU_CYCLES &gt; 0), min((($FrontendBoundC1NanoSTALL_SLOT_FRONTEND / (3 * $FrontendBoundC1NanoCPU_CYCLES)) - ($FrontendBoundC1NanoSTALL_FRONTEND_FLUSH / $FrontendBoundC1NanoCPU_CYCLES)), 1), 0)" name="Frontend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Cache L1I Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 1 instruction cache misses" expression="if((($FrontendCacheL1IBoundC1NanoSTALL_FRONTEND_L1I + $FrontendCacheL1IBoundC1NanoSTALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL1IBoundC1NanoSTALL_FRONTEND_L1I / ($FrontendCacheL1IBoundC1NanoSTALL_FRONTEND_L1I + $FrontendCacheL1IBoundC1NanoSTALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L1I Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Cache L2I Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to memory access latency issues caused by level 2 instruction cache misses" expression="if((($FrontendCacheL2IBoundC1NanoSTALL_FRONTEND_L1I + $FrontendCacheL2IBoundC1NanoSTALL_FRONTEND_MEM) &gt; 0), min(($FrontendCacheL2IBoundC1NanoSTALL_FRONTEND_MEM / ($FrontendCacheL2IBoundC1NanoSTALL_FRONTEND_L1I + $FrontendCacheL2IBoundC1NanoSTALL_FRONTEND_MEM)), 1), 0)" name="Frontend Cache L2I Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Core Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints not related to instruction fetch latency issues caused by memory access components" expression="if(($FrontendCoreBoundC1NanoSTALL_FRONTEND &gt; 0), min(($FrontendCoreBoundC1NanoSTALL_FRONTEND_CPUBOUND / $FrontendCoreBoundC1NanoSTALL_FRONTEND), 1), 0)" name="Frontend Core Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Core Flow Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend as the decode unit is awaiting input from the branch prediction unit" expression="if(($FrontendCoreFlowBoundC1NanoSTALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlowBoundC1NanoSTALL_FRONTEND_FLOW / $FrontendCoreFlowBoundC1NanoSTALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flow Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Core Flush Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend as the processor is recovering from a pipeline flush caused by bad speculation or other machine resteers" expression="if(($FrontendCoreFlushBoundC1NanoSTALL_FRONTEND_CPUBOUND &gt; 0), min(($FrontendCoreFlushBoundC1NanoSTALL_FRONTEND_FLUSH / $FrontendCoreFlushBoundC1NanoSTALL_FRONTEND_CPUBOUND), 1), 0)" name="Frontend Core Flush Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Memory Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to frontend core resource constraints related to the instruction fetch latency issues caused by memory access components" expression="if(($FrontendMemoryBoundC1NanoSTALL_FRONTEND &gt; 0), min(($FrontendMemoryBoundC1NanoSTALL_FRONTEND_MEMBOUND / $FrontendMemoryBoundC1NanoSTALL_FRONTEND), 1), 0)" name="Frontend Memory Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Mem Cache Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction cache misses" expression="if(($FrontendMemCacheBoundC1NanoSTALL_FRONTEND_MEMBOUND &gt; 0), min((($FrontendMemCacheBoundC1NanoSTALL_FRONTEND_L1I + $FrontendMemCacheBoundC1NanoSTALL_FRONTEND_MEM) / $FrontendMemCacheBoundC1NanoSTALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem Cache Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Mem TLB Bound">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the frontend due to instruction fetch latency issues caused by instruction TLB misses" expression="if(($FrontendMemTLBBoundC1NanoSTALL_FRONTEND_MEMBOUND &gt; 0), min(($FrontendMemTLBBoundC1NanoSTALL_FRONTEND_TLB / $FrontendMemTLBBoundC1NanoSTALL_FRONTEND_MEMBOUND), 1), 0)" name="Frontend Mem TLB Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesC1NanoCPU_CYCLES &gt; 0), min(($FrontendStalledCyclesC1NanoSTALL_FRONTEND / $FrontendStalledCyclesC1NanoCPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instruction Fetch Average Latency">
        <series color="19,148,180" description="This metric measures the average latency of instruction fetches in CPU cycles" expression="if(($InstructionFetchAverageLatencyC1NanoINST_FETCH &gt; 0), ($InstructionFetchAverageLatencyC1NanoINST_FETCH_PERCYC / $InstructionFetchAverageLatencyC1NanoINST_FETCH), 0)" name="Instruction Fetch Average Latency" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageC1NanoINST_SPEC &gt; 0), min(($IntegerOperationsPercentageC1NanoDP_SPEC / $IntegerOperationsPercentageC1NanoINST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions Per Cycle">
        <series color="19,148,180" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleC1NanoCPU_CYCLES &gt; 0), ($InstructionsPerCycleC1NanoINST_RETIRED / $InstructionsPerCycleC1NanoCPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="ITLB MPKI">
        <series color="19,148,180" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKIC1NanoINST_RETIRED &gt; 0), (($ITLBMPKIC1NanoITLB_WALK / $ITLBMPKIC1NanoINST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="ITLB Walk Average Depth of Accesses">
        <series color="19,148,180" description="This metric measures the average depth of the instruction TLB walks for an instruction TLB refill" expression="if(($ITLBWalkAverageDepthOfAccessesC1NanoITLB_WALK &gt; 0), ($ITLBWalkAverageDepthOfAccessesC1NanoITLB_STEP / $ITLBWalkAverageDepthOfAccessesC1NanoITLB_WALK), 0)" name="ITLB Walk Average Depth of Accesses" units="accesses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="ITLB Walk Average Latency">
        <series color="19,148,180" description="This metric measures the average latency of instruction TLB walks in CPU cycles" expression="if(($ITLBWalkAverageLatencyC1NanoITLB_WALK &gt; 0), ($ITLBWalkAverageLatencyC1NanoITLB_WALK_PERCYC / $ITLBWalkAverageLatencyC1NanoITLB_WALK), 0)" name="ITLB Walk Average Latency" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Block Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks that returned a block to the total number of instruction TLB accesses. Block size is any memory block larger than the page granule size set by the system." expression="if(($ITLBWalkBlockPercentageC1NanoL1I_TLB &gt; 0), min(($ITLBWalkBlockPercentageC1NanoITLB_WALK_BLOCK / $ITLBWalkBlockPercentageC1NanoL1I_TLB), 1), 0)" name="ITLB Walk Block Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Large Page Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkLargePagePercentageC1NanoL1I_TLB &gt; 0), min(($ITLBWalkLargePagePercentageC1NanoITLB_WALK_LARGE / $ITLBWalkLargePagePercentageC1NanoL1I_TLB), 1), 0)" name="ITLB Walk Large Page Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Page Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks that returned a page to the total number of instruction TLB accesses. Page size is determined by the page granule size set by the system." expression="if(($ITLBWalkPagePercentageC1NanoL1I_TLB &gt; 0), min(($ITLBWalkPagePercentageC1NanoITLB_WALK_PAGE / $ITLBWalkPagePercentageC1NanoL1I_TLB), 1), 0)" name="ITLB Walk Page Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageC1NanoL1I_TLB &gt; 0), min(($ITLBWalkPercentageC1NanoITLB_WALK / $ITLBWalkPercentageC1NanoL1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Small Page Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks that returned large page to the total number of instruction TLB accesses" expression="if(($ITLBWalkSmallPagePercentageC1NanoL1I_TLB &gt; 0), min(($ITLBWalkSmallPagePercentageC1NanoITLB_WALK_SMALL / $ITLBWalkSmallPagePercentageC1NanoL1I_TLB), 1), 0)" name="ITLB Walk Small Page Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageC1NanoL1D_CACHE_RW &gt; 0), min((($L1DCacheMissPercentageC1NanoL1D_CACHE_REFILL_RD + $L1DCacheMissPercentageC1NanoL1D_CACHE_REFILL_WR) / $L1DCacheMissPercentageC1NanoL1D_CACHE_RW), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKIC1NanoINST_RETIRED &gt; 0), ((($L1DCacheMPKIC1NanoL1D_CACHE_REFILL_RD + $L1DCacheMPKIC1NanoL1D_CACHE_REFILL_WR) / $L1DCacheMPKIC1NanoINST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageC1NanoL1D_TLB &gt; 0), min(($L1DataTLBMissPercentageC1NanoL1D_TLB_REFILL / $L1DataTLBMissPercentageC1NanoL1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKIC1NanoINST_RETIRED &gt; 0), (($L1DataTLBMPKIC1NanoL1D_TLB_REFILL / $L1DataTLBMPKIC1NanoINST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageC1NanoL1I_CACHE &gt; 0), min(($L1ICacheMissPercentageC1NanoL1I_CACHE_REFILL / $L1ICacheMissPercentageC1NanoL1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKIC1NanoINST_RETIRED &gt; 0), (($L1ICacheMPKIC1NanoL1I_CACHE_REFILL / $L1ICacheMPKIC1NanoINST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageC1NanoL1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageC1NanoL1I_TLB_REFILL / $L1InstructionTLBMissPercentageC1NanoL1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKIC1NanoINST_RETIRED &gt; 0), (($L1InstructionTLBMPKIC1NanoL1I_TLB_REFILL / $L1InstructionTLBMPKIC1NanoINST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageC1NanoL2D_CACHE_RW &gt; 0), min((($L2CacheMissPercentageC1NanoL2D_CACHE_REFILL_RD + $L2CacheMissPercentageC1NanoL2D_CACHE_REFILL_WR) / $L2CacheMissPercentageC1NanoL2D_CACHE_RW), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKIC1NanoINST_RETIRED &gt; 0), ((($L2CacheMPKIC1NanoL2D_CACHE_REFILL_RD + $L2CacheMPKIC1NanoL2D_CACHE_REFILL_WR) / $L2CacheMPKIC1NanoINST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache Prefetcher Accuracy (L1 HW prefetch exclusive)">
        <series color="19,148,180" description="This metric measures L2D cache prefetcher accuracy excluding L1 hardware prefetch requests" expression="if(($L2CachePrefetcherAccuracyL1HWPrefetchExclusiveC1NanoL2D_CACHE_REFILL_HWPRF &gt; 0), (($L2CachePrefetcherAccuracyL1HWPrefetchExclusiveC1NanoL2D_CACHE_HIT_RW_FHWPRF + $L2CachePrefetcherAccuracyL1HWPrefetchExclusiveC1NanoL2D_LFB_HIT_RW_FHWPRF) / $L2CachePrefetcherAccuracyL1HWPrefetchExclusiveC1NanoL2D_CACHE_REFILL_HWPRF), 0)" name="L2 Cache Prefetcher Accuracy (L1 HW prefetch exclusive)" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache Prefetcher Coverage (L1 HW prefetch exclusive)">
        <series color="19,148,180" description="This metric measures L2D cache prefetcher coverage excluding L1 hardware prefetch requests" expression="if((((($L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1NanoL2D_CACHE_HIT_RW_FHWPRF + $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1NanoL2D_LFB_HIT_RW_FHWPRF) + $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1NanoL2D_CACHE_REFILL_RD) + $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1NanoL2D_CACHE_REFILL_WR) &gt; 0), (($L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1NanoL2D_CACHE_HIT_RW_FHWPRF + $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1NanoL2D_LFB_HIT_RW_FHWPRF) / ((($L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1NanoL2D_CACHE_HIT_RW_FHWPRF + $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1NanoL2D_LFB_HIT_RW_FHWPRF) + $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1NanoL2D_CACHE_REFILL_RD) + $L2CachePrefetcherCoverageL1HWPrefetchExclusiveC1NanoL2D_CACHE_REFILL_WR)), 0)" name="L2 Cache Prefetcher Coverage (L1 HW prefetch exclusive)" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache Prefetcher Timeliness (L1 HW prefetch exclusive)">
        <series color="19,148,180" description="This metric measures L2D cache prefetcher timeliness excluding L1 hardware prefetch requests" expression="if((($L2CachePrefetcherTimelinessL1HWPrefetchExclusiveC1NanoL2D_CACHE_HIT_RW_FHWPRF + $L2CachePrefetcherTimelinessL1HWPrefetchExclusiveC1NanoL2D_LFB_HIT_RW_FHWPRF) &gt; 0), ($L2CachePrefetcherTimelinessL1HWPrefetchExclusiveC1NanoL2D_CACHE_HIT_RW_FHWPRF / ($L2CachePrefetcherTimelinessL1HWPrefetchExclusiveC1NanoL2D_CACHE_HIT_RW_FHWPRF + $L2CachePrefetcherTimelinessL1HWPrefetchExclusiveC1NanoL2D_LFB_HIT_RW_FHWPRF)), 0)" name="L2 Cache Prefetcher Timeliness (L1 HW prefetch exclusive)" units="prefetches"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageC1NanoL2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageC1NanoL2D_TLB_REFILL / $L2UnifiedTLBMissPercentageC1NanoL2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKIC1NanoINST_RETIRED &gt; 0), (($L2UnifiedTLBMPKIC1NanoL2D_TLB_REFILL / $L2UnifiedTLBMPKIC1NanoINST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 cache data accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMissPercentageC1NanoL2D_CACHE_RW &gt; 0), min((($L2DCacheMissPercentageC1NanoL2D_CACHE_REFILL_RD + $L2DCacheMissPercentageC1NanoL2D_CACHE_REFILL_WR) / $L2DCacheMissPercentageC1NanoL2D_CACHE_RW), 1), 0)" name="L2D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMPKIC1NanoINST_RETIRED &gt; 0), ((($L2DCacheMPKIC1NanoL2D_CACHE_REFILL_RD + $L2DCacheMPKIC1NanoL2D_CACHE_REFILL_WR) / $L2DCacheMPKIC1NanoINST_RETIRED) * 1000), 0)" name="L2D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache instruction accesses missed to the total number of level 2 cache instruction accesses. This gives an indication of the effectiveness of instruction accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2ICacheMissPercentageC1NanoL2I_CACHE &gt; 0), min(($L2ICacheMissPercentageC1NanoL2I_CACHE_REFILL / $L2ICacheMissPercentageC1NanoL2I_CACHE), 1), 0)" name="L2I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache instruction accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2ICacheMPKIC1NanoINST_RETIRED &gt; 0), (($L2ICacheMPKIC1NanoL2I_CACHE_REFILL / $L2ICacheMPKIC1NanoINST_RETIRED) * 1000), 0)" name="L2I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageC1NanoL3D_CACHE_RD &gt; 0), min(($L3CacheMissPercentageC1NanoL3D_CACHE_REFILL_RD / $L3CacheMissPercentageC1NanoL3D_CACHE_RD), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKIC1NanoINST_RETIRED &gt; 0), (($L3CacheMPKIC1NanoL3D_CACHE_REFILL_RD / $L3CacheMPKIC1NanoINST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageC1NanoINST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageC1NanoLDREX_SPEC / $LoadExclusiveInstructionsPercentageC1NanoINST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageC1NanoLL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageC1NanoLL_CACHE_RD - $LLCacheReadHitPercentageC1NanoLL_CACHE_MISS_RD) / $LLCacheReadHitPercentageC1NanoLL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageC1NanoLL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageC1NanoLL_CACHE_MISS_RD / $LLCacheReadMissPercentageC1NanoLL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="LL Cache Read MPKI">
        <series color="19,148,180" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKIC1NanoINST_RETIRED &gt; 0), (($LLCacheReadMPKIC1NanoLL_CACHE_MISS_RD / $LLCacheReadMPKIC1NanoINST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Load Operation Average Latency">
        <series color="19,148,180" description="This metric measures the average latency of load operations in CPU cycles" expression="if(($LoadOperationAverageLatencyC1NanoMEM_ACCESS &gt; 0), ($LoadOperationAverageLatencyC1NanoMEM_ACCESS_RD_PERCYC / $LoadOperationAverageLatencyC1NanoMEM_ACCESS), 0)" name="Load Operation Average Latency" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load as Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageC1NanoLDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageC1NanoLD_SPEC / $LoadAsLoadStoreOperationsPercentageC1NanoLDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageC1NanoINST_SPEC &gt; 0), min(($LoadOperationsPercentageC1NanoLD_SPEC / $LoadOperationsPercentageC1NanoINST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageC1NanoINST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageC1NanoLDST_SPEC / $LoadStoreOperationsPercentageC1NanoINST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LSE Atomics Percentage">
        <series color="19,148,180" description="This metric measures the ratio of LSE atomics instructions speculatively executed locally to the PE to the total load and store instructions" expression="if(($LSEAtomicsPercentageC1NanoLDST_SPEC &gt; 0), min(($LSEAtomicsPercentageC1NanoLSE_LDST_SPEC / $LSEAtomicsPercentageC1NanoLDST_SPEC), 1), 0)" name="LSE Atomics Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LSE Load Percentage">
        <series color="19,148,180" description="This metric measures the ratio of LSE load instructions speculatively executed to the total LSE instructions" expression="if(($LSELoadPercentageC1NanoLSE_LDST_SPEC &gt; 0), min(($LSELoadPercentageC1NanoLSE_LD_SPEC / $LSELoadPercentageC1NanoLSE_LDST_SPEC), 1), 0)" name="LSE Load Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LSE Store Percentage">
        <series color="19,148,180" description="This metric measures the ratio of LSE store instructions speculatively executed to the total LSE instructions" expression="if(($LSEStorePercentageC1NanoLSE_LDST_SPEC &gt; 0), min(($LSEStorePercentageC1NanoLSE_ST_SPEC / $LSEStorePercentageC1NanoLSE_LDST_SPEC), 1), 0)" name="LSE Store Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Acquire Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageC1NanoINST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageC1NanoRC_LD_SPEC / $LoadAcquireInstructionsPercentageC1NanoINST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Release Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageC1NanoINST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageC1NanoRC_ST_SPEC / $StoreReleaseInstructionsPercentageC1NanoINST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retired Operations Percentage">
        <series color="19,148,180" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageC1NanoOP_SPEC &gt; 0), min(($RetiredOperationsPercentageC1NanoOP_RETIRED / $RetiredOperationsPercentageC1NanoOP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retiring">
        <series color="19,148,180" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringC1NanoCPU_CYCLES &gt; 0) &amp;&amp; ($RetiringC1NanoOP_SPEC &gt; 0), min(((1 - ($RetiringC1NanoSTALL_SLOT / ($RetiringC1NanoCPU_CYCLES * 3))) * ($RetiringC1NanoOP_RETIRED / $RetiringC1NanoOP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageC1NanoINST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageC1NanoVFP_SPEC / $FloatingPointOperationsPercentageC1NanoINST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Advanced SIMD Operations Percentage">
        <series color="19,148,180" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageC1NanoINST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageC1NanoASE_SPEC / $AdvancedSIMDOperationsPercentageC1NanoINST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SME Operations Percentage">
        <series color="19,148,180" description="This metric measures Scalable Matrix extension data processing operations as a percentage of operations speculatively executed" expression="if(($SMEOperationsPercentageC1NanoINST_SPEC &gt; 0), min(($SMEOperationsPercentageC1NanoSME_INST_SPEC / $SMEOperationsPercentageC1NanoINST_SPEC), 1), 0)" name="SME Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store as Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageC1NanoLDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageC1NanoST_SPEC / $StoreAsLoadStoreOperationsPercentageC1NanoLDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageC1NanoINST_SPEC &gt; 0), min(($StoreOperationsPercentageC1NanoST_SPEC / $StoreOperationsPercentageC1NanoINST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming FP Operations Percentage">
        <series color="19,148,180" description="This metric measures streaming floating point operations as a percentage of streaming operations speculatively executed" expression="if(($StreamingFPOperationsPercentageC1NanoSSVE_INST_SPEC &gt; 0), min(($StreamingFPOperationsPercentageC1NanoSSVE_FP_SPEC / $StreamingFPOperationsPercentageC1NanoSSVE_INST_SPEC), 1), 0)" name="Streaming FP Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures streaming integer operations as a percentage of streaming operations speculatively executed" expression="if(($StreamingIntegerOperationsPercentageC1NanoSSVE_INST_SPEC &gt; 0), min(($StreamingIntegerOperationsPercentageC1NanoSSVE_INT_SPEC / $StreamingIntegerOperationsPercentageC1NanoSSVE_INST_SPEC), 1), 0)" name="Streaming Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming Load Operations Percentage">
        <series color="19,148,180" description="This metric measures streaming load operations as a percentage of streaming operations speculatively executed" expression="if(($StreamingLoadOperationsPercentageC1NanoSSVE_INST_SPEC &gt; 0), min(($StreamingLoadOperationsPercentageC1NanoSSVE_LD_SPEC / $StreamingLoadOperationsPercentageC1NanoSSVE_INST_SPEC), 1), 0)" name="Streaming Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures streaming load and store operations as a percentage of streaming operations speculatively executed" expression="if(($StreamingLoadStoreOperationsPercentageC1NanoSSVE_INST_SPEC &gt; 0), min(($StreamingLoadStoreOperationsPercentageC1NanoSSVE_LDST_SPEC / $StreamingLoadStoreOperationsPercentageC1NanoSSVE_INST_SPEC), 1), 0)" name="Streaming Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming Operations Percentage">
        <series color="19,148,180" description="This metric measures streaming operations as a percentage of operations speculatively executed Streaming operations include Advanced SIMD, Scalable vector or or Scalable Matrix extension data processing when the CPU is in streaming mode" expression="if(($StreamingOperationsPercentageC1NanoINST_SPEC &gt; 0), min(($StreamingOperationsPercentageC1NanoSSVE_INST_SPEC / $StreamingOperationsPercentageC1NanoINST_SPEC), 1), 0)" name="Streaming Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming Slow Instructions Percentage">
        <series color="19,148,180" description="This metric measures streaming slow instructions as a percentage of streaming operations speculatively executed" expression="if(($StreamingSlowInstructionsPercentageC1NanoSSVE_INST_SPEC &gt; 0), min(($StreamingSlowInstructionsPercentageC1NanoSSVE_SLOW_INSTR / $StreamingSlowInstructionsPercentageC1NanoSSVE_INST_SPEC), 1), 0)" name="Streaming Slow Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming Store Operations Percentage">
        <series color="19,148,180" description="This metric measures streaming store operations as a percentage of streaming operations speculatively executed" expression="if(($StreamingStoreOperationsPercentageC1NanoSSVE_INST_SPEC &gt; 0), min(($StreamingStoreOperationsPercentageC1NanoSSVE_ST_SPEC / $StreamingStoreOperationsPercentageC1NanoSSVE_INST_SPEC), 1), 0)" name="Streaming Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Store-Exclusive Failures PKI">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed per thousand instructions speculatively executed" expression="if(($StoreExclusiveFailuresPKIC1NanoINST_SPEC &gt; 0), (($StoreExclusiveFailuresPKIC1NanoSTREX_FAIL_SPEC / $StoreExclusiveFailuresPKIC1NanoINST_SPEC) * 1000), 0)" name="Store-Exclusive Failures PKI" units="failures"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Failures Percentage">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed as a percentage of store-exclusive instructions speculatively executed" expression="if(($StoreExclusiveFailuresPercentageC1NanoSTREX_SPEC &gt; 0), min(($StoreExclusiveFailuresPercentageC1NanoSTREX_FAIL_SPEC / $StoreExclusiveFailuresPercentageC1NanoSTREX_SPEC), 1), 0)" name="Store-Exclusive Failures Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageC1NanoINST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageC1NanoSTREX_SPEC / $StoreExclusiveInstructionsPercentageC1NanoINST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="SVE Floating Point Operations per Cycle">
        <series color="19,148,180" description="This metric measures floating point operations per cycle in any precision performed by SVE instructions. Operations are counted by computation and by vector lanes, fused computations such as multiply-add count as twice per vector lane for example." expression="if(($SVEFloatingPointOperationsPerCycleC1NanoCPU_CYCLES &gt; 0), ($SVEFloatingPointOperationsPerCycleC1NanoFP_SCALE_OPS_SPEC / $SVEFloatingPointOperationsPerCycleC1NanoCPU_CYCLES), 0)" name="SVE Floating Point Operations per Cycle" units="operations"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Operations Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations as a percentage of operations speculatively executed" expression="if(($SVEOperationsPercentageC1NanoINST_SPEC &gt; 0), min(($SVEOperationsPercentageC1NanoSVE_SPEC / $SVEOperationsPercentageC1NanoINST_SPEC), 1), 0)" name="SVE Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Empty Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with no active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEEmptyPredicatePercentageC1NanoSVE_PRED_SPEC &gt; 0), min(($SVEEmptyPredicatePercentageC1NanoSVE_PRED_EMPTY_SPEC / $SVEEmptyPredicatePercentageC1NanoSVE_PRED_SPEC), 1), 0)" name="SVE Empty Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Full Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with all active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEFullPredicatePercentageC1NanoSVE_PRED_SPEC &gt; 0), min(($SVEFullPredicatePercentageC1NanoSVE_PRED_FULL_SPEC / $SVEFullPredicatePercentageC1NanoSVE_PRED_SPEC), 1), 0)" name="SVE Full Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Partial Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with at least one active predicates as a percentage of sve predicated operations speculatively executed" expression="if(($SVEPartialPredicatePercentageC1NanoSVE_PRED_SPEC &gt; 0), min(($SVEPartialPredicatePercentageC1NanoSVE_PRED_PARTIAL_SPEC / $SVEPartialPredicatePercentageC1NanoSVE_PRED_SPEC), 1), 0)" name="SVE Partial Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="SVE Predicate Percentage">
        <series color="19,148,180" description="This metric measures scalable vector operations with predicates as a percentage of operations speculatively executed" expression="if(($SVEPredicatePercentageC1NanoINST_SPEC &gt; 0), min(($SVEPredicatePercentageC1NanoSVE_PRED_SPEC / $SVEPredicatePercentageC1NanoINST_SPEC), 1), 0)" name="SVE Predicate Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ZA Active Cycles Percentage">
        <series color="19,148,180" description="This metric is measures the ratio of cycles when PSTATE. ZA was enabled to the total number of CPU cycles." expression="if(($ZAActiveCyclesPercentageC1NanoCPU_CYCLES &gt; 0), min(($ZAActiveCyclesPercentageC1NanoZA_ACTIVE_CYCLES / $ZAActiveCyclesPercentageC1NanoCPU_CYCLES), 1), 0)" name="ZA Active Cycles Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Add Sub Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures SME/SVE classified floating point addition or subtraction operations that used ZA arrays as a percentage of all the SME floating point ZA operations speculatively executed" expression="if(($StreamingZAAddSubFloatingPointOperationsPercentageC1NanoSME_FP_SPEC &gt; 0), min(($StreamingZAAddSubFloatingPointOperationsPercentageC1NanoSME_FP_ADDSUB_SPEC / $StreamingZAAddSubFloatingPointOperationsPercentageC1NanoSME_FP_SPEC), 1), 0)" name="Streaming ZA Add Sub Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Dot Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures SME/SVE classified floating point dot product operations that used ZA arrays as a percentage of all the SME floating point ZA operations speculatively executed" expression="if(($StreamingZADotFloatingPointOperationsPercentageC1NanoSME_FP_SPEC &gt; 0), min(($StreamingZADotFloatingPointOperationsPercentageC1NanoSME_FP_DOT_SPEC / $StreamingZADotFloatingPointOperationsPercentageC1NanoSME_FP_SPEC), 1), 0)" name="Streaming ZA Dot Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA FMA Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures SME/SVE classified floating point multiply-add, multiply-add long, multiply-subtract and multiply-subtract long operations that used ZA arrays as a percentage of all the SME floating point ZA operations speculatively executed" expression="if(($StreamingZAFMAFloatingPointOperationsPercentageC1NanoSME_FP_SPEC &gt; 0), min(($StreamingZAFMAFloatingPointOperationsPercentageC1NanoSME_FP_FMA_SPEC / $StreamingZAFMAFloatingPointOperationsPercentageC1NanoSME_FP_SPEC), 1), 0)" name="Streaming ZA FMA Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA MOPA Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures SME/SVE classified floating point outer product and accumulate, or outer product and subtract operations that used ZA arrays as a percentage of all the SME integer ZA operations speculatively executed" expression="if(($StreamingZAMOPAFloatingPointOperationsPercentageC1NanoSME_FP_SPEC &gt; 0), min(($StreamingZAMOPAFloatingPointOperationsPercentageC1NanoSME_FP_MOPA_SPEC / $StreamingZAMOPAFloatingPointOperationsPercentageC1NanoSME_FP_SPEC), 1), 0)" name="Streaming ZA MOPA Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures SME/SVE classified floating point operations and used ZA arrays as a percentage of all the SME operations speculatively executed that used ZA array ZA arrays are required for instructions that required PSTATE. ZA to be set." expression="if(($StreamingZAFloatingPointOperationsPercentageC1NanoSME_INST_SPEC &gt; 0), min(($StreamingZAFloatingPointOperationsPercentageC1NanoSME_FP_SPEC / $StreamingZAFloatingPointOperationsPercentageC1NanoSME_INST_SPEC), 1), 0)" name="Streaming ZA Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Other Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures SME/SVE classified floating point operations that used ZA arrays not counted in any other category as a percentage of all the SME floating point ZA operations speculatively executed" expression="if(($StreamingZAOtherFloatingPointOperationsPercentageC1NanoSME_FP_SPEC &gt; 0), min(($StreamingZAOtherFloatingPointOperationsPercentageC1NanoSME_FP_OTHER_SPEC / $StreamingZAOtherFloatingPointOperationsPercentageC1NanoSME_FP_SPEC), 1), 0)" name="Streaming ZA Other Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Dot Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures SME integer dot product operations that used ZA arrays as a percentage of all the SME integer ZA operations speculatively executed" expression="if(($StreamingZADotIntegerOperationsPercentageC1NanoSME_INT_SPEC &gt; 0), min(($StreamingZADotIntegerOperationsPercentageC1NanoSME_INT_DOT_SPEC / $StreamingZADotIntegerOperationsPercentageC1NanoSME_INT_SPEC), 1), 0)" name="Streaming ZA Dot Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA MOPA Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures SME integer outer product and accumulate, or outer product and subtract operations that used ZA arrays as a percentage of all the SME integer ZA operations speculatively executed" expression="if(($StreamingZAMOPAIntegerOperationsPercentageC1NanoSME_INT_SPEC &gt; 0), min(($StreamingZAMOPAIntegerOperationsPercentageC1NanoSME_INT_MOPA_SPEC / $StreamingZAMOPAIntegerOperationsPercentageC1NanoSME_INT_SPEC), 1), 0)" name="Streaming ZA MOPA Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures SME integer operations that used ZA arrays as a percentage of all the SME operations speculatively executed that used ZA array ZA arrays are required for instructions that required PSTATE. ZA to be set." expression="if(($StreamingZAIntegerOperationsPercentageC1NanoSME_INST_SPEC &gt; 0), min(($StreamingZAIntegerOperationsPercentageC1NanoSME_INT_SPEC / $StreamingZAIntegerOperationsPercentageC1NanoSME_INST_SPEC), 1), 0)" name="Streaming ZA Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Other Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures SME integer operations that used ZA arrays not counted in any other category as a percentage of all the SME integer ZA operations speculatively executed" expression="if(($StreamingZAOtherIntegerOperationsPercentageC1NanoSME_INT_SPEC &gt; 0), min(($StreamingZAOtherIntegerOperationsPercentageC1NanoSME_INT_OTHER_SPEC / $StreamingZAOtherIntegerOperationsPercentageC1NanoSME_INT_SPEC), 1), 0)" name="Streaming ZA Other Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Streaming ZA Operations Percentage">
        <series color="19,148,180" description="This metric measures SME operations that used ZA arrays as a percentage of operations speculatively executed ZA arrays are required for instructions that required PSTATE. ZA to be set." expression="if(($StreamingZAOperationsPercentageC1NanoINST_SPEC &gt; 0), min(($StreamingZAOperationsPercentageC1NanoSME_INST_SPEC / $StreamingZAOperationsPercentageC1NanoINST_SPEC), 1), 0)" name="Streaming ZA Operations Percentage" units="percent"/>
    </chart>
    <select-metric id="ARMv9_C1_Nano_metric_backend_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_busy_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_busy_ls_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_busy_vpu_arb_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_cache_l1d_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_cache_l2d_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_cme_backpressure_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_cme_busy_arb_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_cme_busy_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_cme_cpu_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_core_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_core_cme_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_mem_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_mem_cache_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_mem_cme_barrier_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_mem_cme_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_mem_cme_hazard_cpu_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_mem_cme_lsrt_full_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_mem_cpu_hazard_cme_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_mem_store_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_mem_tlb_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_stall_interlock_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_stall_interlock_ls_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_stall_interlock_ptr_chase_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_stall_interlock_vpu_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_backend_stalled_cycles" />
    <select-metric id="ARMv9_C1_Nano_metric_bad_speculation" />
    <select-metric id="ARMv9_C1_Nano_metric_branch_direct_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_branch_indirect_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_branch_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_branch_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_branch_return_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_bus_read_requests_average_latency" />
    <select-metric id="ARMv9_C1_Nano_metric_cas_far_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cas_near_fail_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cas_near_pass_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cas_near_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_alloc_cycles_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_alu_port_utilization" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_arb_pending_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_backend_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_backend_core_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_backend_mem_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_backend_mem_cache_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_backend_mem_store_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_backend_prefetch_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_bus_access_average_length" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_frontend_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_frontend_cpu_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_frontend_other_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_ipc" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_iq_dp0_stall_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_iq_dp1_stall_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_iq_load_stall_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_l1_prefetcher_accuracy" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_l1_prefetcher_coverage" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_l1_prefetcher_timeliness" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_l1d_cache_hit_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_l1d_cache_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_l3d_cache_hit_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_l3d_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_l3d_cache_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_ll_cache_read_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_load_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_mac_port_utilization" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_mmdp_port_utilization" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_mmmv_port_utilization" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_perm_port_utilization" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_retiring" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_st_port_utilization" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_store_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_system_dram_mem_hit_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_system_l3d_cache_hit_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cme_system_ll_cache_hit_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_cpi" />
    <select-metric id="ARMv9_C1_Nano_metric_crypto_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_dtlb_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_dtlb_walk_average_depth" />
    <select-metric id="ARMv9_C1_Nano_metric_dtlb_walk_average_latency" />
    <select-metric id="ARMv9_C1_Nano_metric_dtlb_walk_block_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_dtlb_walk_large_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_dtlb_walk_page_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_dtlb_walk_small_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_fp16_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_fp32_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_fp64_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_frontend_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_frontend_cache_l1i_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_frontend_cache_l2i_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_frontend_core_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_frontend_core_flow_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_frontend_core_flush_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_frontend_mem_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_frontend_mem_cache_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_frontend_mem_tlb_bound" />
    <select-metric id="ARMv9_C1_Nano_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv9_C1_Nano_metric_instruction_fetch_average_latency" />
    <select-metric id="ARMv9_C1_Nano_metric_integer_dp_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_ipc" />
    <select-metric id="ARMv9_C1_Nano_metric_itlb_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_itlb_walk_average_depth" />
    <select-metric id="ARMv9_C1_Nano_metric_itlb_walk_average_latency" />
    <select-metric id="ARMv9_C1_Nano_metric_itlb_walk_block_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_itlb_walk_large_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_itlb_walk_page_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_itlb_walk_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_itlb_walk_small_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_l1d_cache_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_l1i_cache_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_l2_cache_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_l2_prefetcher_accuracy_l1hwprf_exclusive" />
    <select-metric id="ARMv9_C1_Nano_metric_l2_prefetcher_coverage_l1hwprf_exclusive" />
    <select-metric id="ARMv9_C1_Nano_metric_l2_prefetcher_timeliness_l1hwprf_exclusive" />
    <select-metric id="ARMv9_C1_Nano_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_l2_tlb_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_l2d_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_l2d_cache_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_l2i_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_l2i_cache_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_l3_cache_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_ldrex_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_load_average_latency" />
    <select-metric id="ARMv9_C1_Nano_metric_load_ls_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_load_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_load_store_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_lse_atomics_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_lse_load_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_lse_store_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_rc_ld_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_rc_st_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_retired_ops_percent" />
    <select-metric id="ARMv9_C1_Nano_metric_retiring" />
    <select-metric id="ARMv9_C1_Nano_metric_scalar_fp_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_simd_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_sme_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_store_ls_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_store_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_streaming_fp_op_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_streaming_int_op_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_streaming_ld_op_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_streaming_ls_op_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_streaming_op_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_streaming_slow_inst_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_streaming_st_op_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_strex_fail_mpki" />
    <select-metric id="ARMv9_C1_Nano_metric_strex_fail_percent" />
    <select-metric id="ARMv9_C1_Nano_metric_strex_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_sve_fp_ops_per_cycle" />
    <select-metric id="ARMv9_C1_Nano_metric_sve_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_sve_predicate_empty_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_sve_predicate_full_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_sve_predicate_partial_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_sve_predicate_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_za_active_cycles_ratio" />
    <select-metric id="ARMv9_C1_Nano_metric_za_fp_addsub_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_za_fp_dot_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_za_fp_fma_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_za_fp_mopa_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_za_fp_op_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_za_fp_other_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_za_int_dot_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_za_int_mopa_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_za_int_op_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_za_int_other_percentage" />
    <select-metric id="ARMv9_C1_Nano_metric_za_op_percentage" />
</template>
